<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'en'
 *
 * @package     theme_boost_magnific
 * @copyright   2024 Eduardo kraus (http://eduardokraus.com)
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['acessar'] = 'Access Course';
$string['background_color'] = 'Background Color';
$string['background_color_desc'] = 'Top and Footer background color!';
$string['background_color_random'] = 'Random Theme {$a}';
$string['choosereadme'] = 'Boost Magnific is a theme crafted with care to bring cheerful colors to Moodle.';
$string['contact_address'] = 'Address';
$string['contact_email'] = 'Email';
$string['contact_phone'] = 'Phone Number';
$string['content_pagefonts'] = 'Google Extra Fonts';
$string['content_pagefonts_desc'] = 'Add here the @import link from Google for extra fonts.<br>You can put multiple import.<br><a href="https://fonts.google.com/selection/embed" target="google">Embed code</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Moodle default';
$string['content_type_empty'] = '(No content)';
$string['content_type_footer'] = 'Content type for footer';
$string['content_type_footer_desc'] = 'Select the type of content you want to display in the footer.';
$string['content_type_home'] = 'Content type for homepage';
$string['content_type_home_desc'] = 'Select the type of content you want to display on the homepage.';
$string['content_type_html'] = 'Page to be created with editor';
$string['continuar'] = 'Continue studying';
$string['countlesson'] = '{$a} lesson';
$string['countlessons'] = '{$a} lessons';
$string['customcss'] = 'Custom CSS';
$string['customcss_desc'] = 'Any CSS rules you add to this text area will be reflected on all pages, making it easy to customize this theme.';
$string['custommenuitems'] = 'Custom Top Menu Items';
$string['custommenuitems_desc'] = 'You can create a custom menu alongside the top menus. The root menu should start flush with the edge, and submenus should be preceded by a hyphen (-). The number of hyphens determines the item depth. Thus, items with a single hyphen appear in a submenu below the previous top-level item, and items with two hyphens appear in a submenu below the preceding submenu.
The content of each menu item should consist of up to three elements (<strong>label</strong> | <strong>url</strong> | <strong>tooltip</strong> | <strong>lang</strong>), each separated by the "|" character.
<ul>
<li><strong>label</strong>: This is the text that will be displayed within the menu item. You must specify a label for each menu item.</li>
<li><strong>url</strong>: This is the URL to which the user will be taken upon clicking the menu item. This is optional; if not provided, the item will not be linked anywhere.<br>
Other attributes such as "target" can be appended to the end of the URL.</li>
<li><strong>tooltip</strong>: If you provide a URL, you can also choose to provide a tooltip for the link created with the URL. This is optional, and if not defined, the label is used as the tooltip for the menu item.</li>
<li><strong>lang</strong>: You can add a language code (or a comma-separated list of codes) as the fourth element of the line. The line will be displayed only if the user has selected the listed language(s).</li>
</ul>
Below is an example of how you would create a custom menu:
<blockquote><pre>
Courses
-All courses | /course/
-My courses
--Example Course
---Example Course 7 | /course/view.php?id=7
---Example Course 9 | /course/view.php?id=9
--Test Course
---Test Course 2 | /course/view.php?id=2
---Test Course 5 | /course/view.php?id=5
Google
-Google in any language | https://google.com/" target="_blank
-Google in Mexico | https://www.google.com.mx/" target="_blank|Google Label|en
-Google in Portuguese | https://google.com.br/" target="_blank|Google Label|pt,pt_br,pt_br_kids
Support Page | https://support.com/" target="_blank
</pre></blockquote>
For Moodle with support for multiple languages, the <strong>label</strong> value should be formatted as <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">More menu information</a>';
$string['editor_link_footer'] = 'Edit the footer block for {$a} language';
$string['editor_link_footer_all'] = 'Edit the footer block for all languages';
$string['editor_link_home'] = 'Edit the homepage for {$a} language';
$string['editor_link_home_all'] = 'Edit the homepage for all languages';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'The favicon is displayed next to the page title in the browser tab. A Moodle favicon is displayed if a custom favicon is not provided.';
$string['fontfamily'] = 'Site Text Fonts';
$string['fontfamily_desc'] = 'Choose which font you want to use for the text on your Moodle site.';
$string['fontfamily_menus'] = 'Menu Fonts';
$string['fontfamily_menus_desc'] = 'Choose which font you want to use for menus on your Moodle site.';
$string['fontfamily_sitename'] = 'Font for the site name';
$string['fontfamily_sitename_desc'] = 'The font that will be applied to the site name if a logo is not provided.';
$string['fontfamily_title'] = 'Title Text Fonts';
$string['fontfamily_title_desc'] = 'Choose which font you want to use for titles on your Moodle site.';
$string['fontpreview'] = 'Font List Preview';
$string['footer_contact_title'] = 'Contact Block Title';
$string['footer_contact_title_default'] = 'Contact us';
$string['footer_contact_title_desc'] = 'Enter the title of the block that will appear in the footer with the contact details.';
$string['footer_description'] = 'Description';
$string['footer_description_desc'] = 'Describe your Moodle, what you do, and this information will be shown below the logo in the Moodle footer';
$string['footer_frontpage_blockcourses_instructor'] = 'Show Professor\'s name';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'If checked, shows the names of professors in the course list!';
$string['footer_frontpage_blockcourses_text'] = 'Short text explaining the "{$a}" block';
$string['footer_frontpage_blockcourses_text_desc'] = 'Add a text talking about "{$a}"!';
$string['footer_links_title'] = 'Links Block Title';
$string['footer_links_title_default'] = 'Important Links';
$string['footer_show_copywriter'] = 'Show Made with ❤️';
$string['footer_show_copywriter_desc'] = 'Uncheck if you want to hide the "Made with ❤️"';
$string['footer_social_title'] = 'Social Links Block Title';
$string['footer_social_title_default'] = 'Follow us on social media';
$string['footer_social_title_desc'] = 'Enter the title of the block that will appear in the footer with the data from your social networks.';
$string['footerblink'] = 'Footer Block Links';
$string['footerblink_desc'] = 'You can configure a Footer Block Links here to be shown by themes.<br>Each line consists of some menu text or language key or text, a link URL (optional), separated by vertical bars. For example:<br><pre>Moodle Support|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Contact block';
$string['footerblock_copywriter'] = 'Made with ❤️';
$string['footerblock_description'] = 'Description block';
$string['footerblock_links'] = 'Links block';
$string['footerblock_social'] = 'Social block';
$string['free_name'] = 'Free';
$string['frontpage_about_description'] = 'Describe what you do';
$string['frontpage_about_description_desc'] = 'Describe in a maximum of 5 lines the purpose of your Moodle';
$string['frontpage_about_enable'] = 'Enable About block';
$string['frontpage_about_enable_desc'] = 'If checked, the About Block will appear below the Banner!';
$string['frontpage_about_info'] = 'Data box {$a}';
$string['frontpage_about_logo'] = 'Different logo to be shown here';
$string['frontpage_about_logo_desc'] = 'If set, this logo will be used here instead of the Top logo.<br>Blank uses the Top Logo!';
$string['frontpage_about_number'] = 'Amount of data';
$string['frontpage_about_number_desc'] = 'Enter the amount of information mentioned above';
$string['frontpage_about_text'] = 'Data name';
$string['frontpage_about_text_1_defalt'] = 'Courses';
$string['frontpage_about_text_2_defalt'] = 'Teachers';
$string['frontpage_about_text_3_defalt'] = 'Students';
$string['frontpage_about_text_4_defalt'] = 'Lessons';
$string['frontpage_about_text_desc'] = 'Enter the name of the data to be shown on the home';
$string['frontpage_about_title'] = 'About block title';
$string['frontpage_about_title_default'] = 'Our Global Community';
$string['heart'] = 'If you like this theme, don\'t forget to click ❤️ on the themes page <a href="{$a}" target="_blank">by clicking here</a>';
$string['instructor'] = 'Instructor';
$string['login_backgroundcolor'] = 'Background Color';
$string['login_backgroundcolor_desc'] = 'Select the background color of the password recovery page';
$string['login_backgroundfoto'] = 'Background Image';
$string['login_backgroundfoto_desc'] = 'Select the Login/Password Recovery/Create Account background image. Default image is: {$a}';
$string['login_forgot_description'] = 'Text on the side of the Forgot Password Screen';
$string['login_forgot_description_desc'] = 'Text that will appear only on the Forgot Password screen';
$string['login_login_description'] = 'Text on the side of the Login Screen';
$string['login_login_description_desc'] = 'Text that will appear only on the Login screen';
$string['login_signup_description'] = 'Text on the side of the Create an Account Screen';
$string['login_signup_description_desc'] = 'Text that will appear only on the Create an Account screen';
$string['login_theme'] = 'Login theme';
$string['login_theme_block'] = 'Central white block with optional background';
$string['login_theme_desc'] = 'Choose which theme you want in the Login area';
$string['login_theme_image_login'] = 'Background image and login on the side';
$string['login_theme_imagetext_login'] = 'Background image, text over the image, and login on the side';
$string['login_theme_login'] = 'Login screen only, no side image';
$string['logo_color'] = 'Colored Logo';
$string['logo_color_desc'] = 'Please upload your colored LOGO if you want to include it at the top. This logo will be displayed as the page is scrolled, and the menu will be displayed on a white background.';
$string['logo_write'] = 'Top menu logo on scroll';
$string['logo_write_desc'] = 'Please upload your logo if you wish to include it at the top. This logo will be displayed when scrolling remains at the top, and the menu will be displayed on a colored background.';
$string['matricular'] = 'Enroll';
$string['mycourses_color'] = 'Block Background Color';
$string['mycourses_color_desc'] = 'The background color for the block.';
$string['mycourses_icon'] = 'Icon';
$string['mycourses_icon_desc'] = 'A representative icon for the block. Icon size should be 48x48 pixels.';
$string['mycourses_info'] = 'Block {$a}';
$string['mycourses_numblocos'] = 'No blocks';
$string['mycourses_numblocos_desc'] = 'How many images do you want in the SlideShow?';
$string['mycourses_numblocos_nenhum'] = 'No slides on the homepage';
$string['mycourses_title'] = 'Short Block Title';
$string['mycourses_title_desc'] = 'A short and descriptive title for the block.';
$string['mycourses_url'] = 'Block Link';
$string['mycourses_url_desc'] = 'The URL to navigate to when clicking the block. It can be an external link or an internal link within the platform.';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'The Boost Magnific theme does not store any personal data about any user.';
$string['settings_about_heading'] = 'About your Moodle';
$string['settings_css_heading'] = 'Fonts and CSS';
$string['settings_footer_heading'] = 'Footer Block';
$string['settings_icons_block'] = 'Icon {$a}';
$string['settings_icons_change_icons'] = 'Change the default icon in the course list';
$string['settings_icons_default_audio_file'] = 'Audio';
$string['settings_icons_default_book'] = 'Book';
$string['settings_icons_default_download'] = 'Download';
$string['settings_icons_default_game'] = 'Game';
$string['settings_icons_default_money'] = 'Financial';
$string['settings_icons_default_slide'] = 'Slides';
$string['settings_icons_default_support'] = 'Support';
$string['settings_icons_default_video_file'] = 'Video';
$string['settings_icons_heading'] = 'Icons';
$string['settings_icons_image'] = 'Icon Image';
$string['settings_icons_image_desc'] = 'Upload the SVG or PNG image of the desired icon to replace in the course.<br>Recommended size: 24px. If PNG, remember transparency.';
$string['settings_icons_module_disable'] = 'Custom icon selection is disabled. Activate in {$a}';
$string['settings_icons_name'] = 'Icon Name';
$string['settings_icons_name_desc'] = 'Add the icon name for easy selection in the module';
$string['settings_icons_none'] = 'No custom icons';
$string['settings_icons_num'] = 'Number of Icons';
$string['settings_icons_num_desc'] = 'Quantity of custom icons you want to add';
$string['settings_icons_select_icon'] = 'Select the custom icon. Edit in {$a}';
$string['settings_login_heading'] = 'Login Screen';
$string['settings_mycourses_heading'] = 'My Courses Blocks';
$string['settings_slideshow_heading'] = 'SlideShow';
$string['settings_theme_heading'] = 'Theme';
$string['settings_top_heading'] = 'Top Menu';
$string['sitefonts'] = 'Additional Google Fonts';
$string['sitefonts_desc'] = 'Insert the @import code from Google Fonts as indicated in the image below. After saving, the "Site Font" field will be updated, displaying these fonts. You can add multiple @import as needed.';
$string['slidecaption_desc'] = 'Enter the caption text to be used on the slide';
$string['slideshow_image'] = 'Slide Image';
$string['slideshow_image_desc'] = 'The image should be 1250px X 400px.';
$string['slideshow_info'] = 'Slide {$a}';
$string['slideshow_numslides'] = 'How many images in the SlideShow';
$string['slideshow_numslides_desc'] = 'How many images do you want in the SlideShow?';
$string['slideshow_numslides_nenhum'] = 'No slides on the Home';
$string['slideshow_text'] = 'Short descriptive text for the Slide';
$string['slideshow_text_desc'] = 'Insert a short text about the slide.';
$string['slideshow_url'] = 'Slides button link';
$string['slideshow_url_desc'] = 'Insert the destination link for the slide image button';
$string['social_facebook'] = 'Your Facebook';
$string['social_facebook_desc'] = 'Your organization\'s Facebook URL.';
$string['social_instagram'] = 'Your Instagram';
$string['social_instagram_desc'] = 'Your organization\'s Instagram URL.';
$string['social_linkedin'] = 'Your Linkedin';
$string['social_linkedin_desc'] = 'Your organization\'s Linkedin URL.';
$string['social_twitter'] = 'Your Twitter';
$string['social_twitter_desc'] = 'Your organization\'s Twitter URL.';
$string['social_youtube'] = 'Your Youtube';
$string['social_youtube_desc'] = 'Your organization\'s Youtube URL.';
$string['theme_boost_magnific_about_editbooton'] = 'Edit About block';
$string['theme_boost_magnific_frontpage_bloco'] = 'Block "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Home blocks';
$string['theme_boost_magnific_mycourses_editbooton'] = 'Edit Blocks';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Edit SlideShow';
$string['theme_color'] = 'Color Selection';
$string['theme_color-color_buttons'] = 'Buttons Color';
$string['theme_color-color_buttons_desc'] = 'The color used for buttons, adding visual cohesion and emphasizing interactive actions.';
$string['theme_color-color_names'] = 'Names Color';
$string['theme_color-color_names_desc'] = 'Color used to highlight names or identifiers, providing clarity and emphasis on specific text information.';
$string['theme_color-color_primary'] = 'Primary Color';
$string['theme_color-color_primary_desc'] = 'The main primary color of the theme, usually used for highlight and emphasis elements.';
$string['theme_color-color_secondary'] = 'Secondary Color';
$string['theme_color-color_secondary_desc'] = 'A secondary color that complements the primary color, used to highlight secondary elements or to contrast with the primary color.';
$string['theme_color-color_titles'] = 'Titles Color';
$string['theme_color-color_titles_desc'] = 'The color used for titles, providing highlight and visual structure to the page content.';
$string['theme_color_blue'] = 'Blue';
$string['theme_color_desc'] = 'Select the colors of Moodle texts and buttons or click the line below:';
$string['theme_color_green'] = 'Green';
$string['theme_color_green_d'] = 'Dark Green';
$string['theme_color_heading'] = 'Environment Color Selection';
$string['theme_color_red_d'] = 'Red';
$string['theme_color_sugestion'] = 'Color suggestion';
$string['theme_color_sugestion_text'] = 'Click on the line to apply the color to the fields below:';
$string['theme_color_violet'] = 'Purple';
$string['theme_login_branco'] = 'Login screen only, no side image, with the form on a white background';
$string['top_color_heading'] = 'Scroll Top Color';
$string['top_scroll'] = 'Pin the menu when scrolling the page';
$string['top_scroll_background_color'] = 'Background Color of Top Menu on Scroll';
$string['top_scroll_background_color_desc'] = 'Set the background color when scrolling the page.';
$string['top_scroll_desc'] = 'When enabled, the menu will be pinned to the top of the screen while you scroll the page, ensuring easy access to menu options.';
$string['top_scroll_text_color'] = 'Text Color of Menu on Scroll';
$string['top_scroll_text_color_desc'] = 'Set the text color of the menu when scrolling the page.';
$string['vvveb_footer_contact_title_default'] = 'Contact us';
$string['vvveb_home_access'] = 'Access course';
$string['vvveb_home_automatically_my_course'] = 'Do not edit. This block will be automatically replaced with the courses the student is enrolled in.';
$string['vvveb_home_mycourses_heading'] = 'My Courses';
$string['vvveb_home_popular_course'] = 'Popular Courses';
$string['vvveb_home_team_subtitle'] = 'We are a group of professionals dedicated to their work';
$string['vvveb_home_team_title'] = 'Meet Our Team';
